/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.git.core.model;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.ArrayUtil;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.IOUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.filewatcher.FileWatcher;
import com.aptana.git.core.GitPlugin;
import com.aptana.git.core.github.IGithubManager;
import com.aptana.git.core.github.IGithubRepository;
import com.aptana.git.core.model.BranchAddedEvent;
import com.aptana.git.core.model.BranchChangedEvent;
import com.aptana.git.core.model.BranchRemovedEvent;
import com.aptana.git.core.model.ChangedFile;
import com.aptana.git.core.model.GitExecutable;
import com.aptana.git.core.model.GitIndex;
import com.aptana.git.core.model.GitRef;
import com.aptana.git.core.model.GitRevSpecifier;
import com.aptana.git.core.model.IGitRepositoryListener;
import com.aptana.git.core.model.IndexChangedEvent;
import com.aptana.git.core.model.Messages;
import com.aptana.git.core.model.PullEvent;
import com.aptana.git.core.model.PushEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.contentobjects.jnotify.JNotifyAdapter;
import net.contentobjects.jnotify.JNotifyException;
import net.contentobjects.jnotify.JNotifyListener;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitRepository {
    public static final char BRANCH_DELIMITER = '/';
    private static final String DOT_LOCK = ".lock";
    static final String CONFIG_FILENAME = "config";
    private static final String GITHUB_COM = "github.com";
    public static final String GITIGNORE = ".gitignore";
    private static final String PACKED_REFS = "packed-refs";
    static final String COMMIT_EDITMSG = "COMMIT_EDITMSG";
    private static final String SQUASH_MSG = "SQUASH_MSG";
    private static final String MERGE_MSG = "MERGE_MSG";
    private static final String INDEX = "index";
    private static final String ORIG_HEAD = "ORIG_HEAD";
    private static final String MERGE_HEAD_FILENAME = "MERGE_HEAD";
    public static final String HEAD = "HEAD";
    public static final String ORIGIN = "origin";
    public static final String GIT_DIR = ".git";
    private static final Pattern fgRemoteNamePattern = Pattern.compile("\\[remote \"(.+?)\"\\]");
    private static final Pattern fgRemoteURLPattern = Pattern.compile("\\[remote \"(.+?)\"\\](\\s+[^\\[]+)?\\s+url = (.+?)\\s+");
    private static final String GITHUB_REMOTE_REGEX = "((.+?github\\.com:)|((git|https)://github\\.com/))([^/]+?)/(.+?)\\.git";
    public static final int NO_GITHUB_REMOTE_CODE = 1235;
    private ReadWriteLock monitor = new ReentrantReadWriteLock();
    private Set<GitRevSpecifier> branches;
    Map<String, List<GitRef>> refs;
    private URI fileURL;
    private GitRevSpecifier _headRef;
    private GitIndex index;
    private boolean hasChanged;
    private GitRevSpecifier currentBranch;
    private Set<Integer> fileWatcherIds = new HashSet<Integer>();
    private int remoteDirCreationWatchId = -1;
    private Set<IGitRepositoryListener> listeners;

    GitRepository(URI fileURL) {
        this.fileURL = fileURL;
        this.branches = new HashSet<GitRevSpecifier>();
        this.reloadRefs();
        this.readCurrentBranch();
        if (EclipseUtil.isTesting()) {
            return;
        }
        final GitRepository self = this;
        try {
            this.fileWatcherIds.add(FileWatcher.addWatch((String)this.gitDirPath().toOSString(), (int)15, (boolean)false, (JNotifyListener)new JNotifyAdapter(){
                private Set<String> filesToWatch;

                public void fileRenamed(int wd, String rootPath, String oldName, String newName) {
                    if (newName == null || !this.filesToWatch().contains(newName)) {
                        return;
                    }
                    if (newName.equals(GitRepository.HEAD)) {
                        this.checkForBranchChange();
                    } else if (newName.equals(GitRepository.INDEX) || newName.equals(GitRepository.COMMIT_EDITMSG)) {
                        this.refreshIndex();
                    }
                }

                public void fileCreated(int wd, String rootPath, String name) {
                    if (name == null) {
                        return;
                    }
                    if (name.equals(GitRepository.INDEX)) {
                        this.refreshIndex();
                    } else if (name.equals(GitRepository.ORIG_HEAD)) {
                        GitRepository.this.firePullEvent();
                    }
                }

                public void fileDeleted(int wd, String rootPath, String name) {
                    if (name != null && name.equals(GitRepository.INDEX)) {
                        this.refreshIndex();
                    }
                }

                private Set<String> filesToWatch() {
                    if (this.filesToWatch == null) {
                        this.filesToWatch = new HashSet<String>();
                        this.filesToWatch.add(GitRepository.HEAD);
                        this.filesToWatch.add(GitRepository.INDEX);
                        this.filesToWatch.add(GitRepository.COMMIT_EDITMSG);
                    }
                    return this.filesToWatch;
                }

                public void fileModified(int wd, String rootPath, String name) {
                    if (name == null || !this.filesToWatch().contains(name)) {
                        return;
                    }
                    if (name.equals(GitRepository.HEAD)) {
                        this.checkForBranchChange();
                    } else if (name.equals(GitRepository.INDEX) || name.equals(GitRepository.COMMIT_EDITMSG)) {
                        this.refreshIndex();
                    }
                }

                private void refreshIndex() {
                    GitRepository.this.index().scheduleBatchRefresh();
                }

                protected void checkForBranchChange() {
                    GitRepoJob job = new GitRepoJob(GitRepository.this, self, "Checking for current branch switch"){

                        protected IStatus run(IProgressMonitor monitor) {
                            String oldBranchName = GitRepository.this.currentBranch.simpleRef().shortName();
                            GitRepository.this._headRef = null;
                            GitRepository.this.readCurrentBranch();
                            String newBranchName = GitRepository.this.currentBranch.simpleRef().shortName();
                            if (oldBranchName.equals(newBranchName)) {
                                return Status.OK_STATUS;
                            }
                            GitRepository.this.fireBranchChangeEvent(oldBranchName, newBranchName);
                            return Status.OK_STATUS;
                        }
                    };
                    job.schedule();
                }
            }));
            if (this.gitFile("refs/remotes/").isDirectory()) {
                this.addRemotesFileWatcher();
            } else {
                this.remoteDirCreationWatchId = FileWatcher.addWatch((String)this.gitFile("refs/").getAbsolutePath(), (int)1, (boolean)false, (JNotifyListener)new JNotifyAdapter(){

                    public void fileCreated(int wd, String rootPath, String name) {
                        if (name != null && name.equals("remotes")) {
                            try {
                                GitRepository.this.addRemotesFileWatcher();
                            }
                            catch (JNotifyException e) {
                                IdeLog.logWarning((Plugin)GitPlugin.getDefault(), (Throwable)e, (String)"com.aptana.git.core/debug");
                            }
                            if (GitRepository.this.remoteDirCreationWatchId == -1) {
                                return;
                            }
                            GitRepoJob job = new GitRepoJob(GitRepository.this, self, "Removing file watcher on remotes dir creation"){

                                protected IStatus run(IProgressMonitor monitor) {
                                    try {
                                        FileWatcher.removeWatch((int)GitRepository.this.remoteDirCreationWatchId);
                                    }
                                    catch (JNotifyException e) {
                                        IdeLog.logWarning((Plugin)GitPlugin.getDefault(), (Throwable)e, (String)"com.aptana.git.core/debug");
                                    }
                                    return Status.OK_STATUS;
                                }
                            };
                            job.schedule();
                        }
                    }
                });
                this.fileWatcherIds.add(this.remoteDirCreationWatchId);
            }
            this.fileWatcherIds.add(FileWatcher.addWatch((String)this.gitFile("refs/heads/").getAbsolutePath(), (int)3, (boolean)false, (JNotifyListener)new JNotifyAdapter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void fileDeleted(int wd, String rootPath, final String name) {
                    if (name == null || name.endsWith(GitRepository.DOT_LOCK) || GitRepository.this.branches == null) {
                        return;
                    }
                    final GitRevSpecifier rev = new GitRevSpecifier(GitRef.refFromString("refs/heads/" + name));
                    Set set = GitRepository.this.branches;
                    synchronized (set) {
                        GitRepository.this.branches.remove(rev);
                    }
                    GitRepoJob job = new GitRepoJob(GitRepository.this, self, "Handle branch removal"){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        protected IStatus run(IProgressMonitor monitor) {
                            GitRepository.this.reloadRefs();
                            if (GitRepository.this.branches == null) {
                                return Status.OK_STATUS;
                            }
                            boolean contains = false;
                            Set set = GitRepository.this.branches;
                            synchronized (set) {
                                contains = GitRepository.this.branches.contains(rev);
                            }
                            if (!contains) {
                                GitRepository.this.fireBranchRemovedEvent(name);
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    job.schedule();
                }

                public void fileCreated(int wd, String rootPath, final String name) {
                    if (name == null || name.endsWith(GitRepository.DOT_LOCK)) {
                        return;
                    }
                    GitRepository.this.addBranch(new GitRevSpecifier(GitRef.refFromString("refs/heads/" + name)));
                    GitRepoJob job = new GitRepoJob(GitRepository.this, self, "Checking if HEAD changed"){

                        protected IStatus run(IProgressMonitor monitor) {
                            GitRepository.this.fireBranchAddedEvent(name);
                            String oldBranchName = GitRepository.this.currentBranch.simpleRef().shortName();
                            if (oldBranchName.equals(name)) {
                                return Status.OK_STATUS;
                            }
                            GitRepository.this._headRef = null;
                            GitRepository.this.readCurrentBranch();
                            GitRepository.this.fireBranchChangeEvent(oldBranchName, name);
                            return Status.OK_STATUS;
                        }
                    };
                    job.schedule();
                }
            }));
        }
        catch (JNotifyException e) {
            IdeLog.logWarning((Plugin)GitPlugin.getDefault(), (Throwable)e, (String)"com.aptana.git.core/debug");
        }
    }

    private void addRemotesFileWatcher() throws JNotifyException {
        this.fileWatcherIds.add(FileWatcher.addWatch((String)this.gitFile("refs/remotes/").getAbsolutePath(), (int)15, (boolean)true, (JNotifyListener)new JNotifyListener(){

            public void fileRenamed(int wd, String rootPath, String oldName, String newName) {
                if (newName == null) {
                    return;
                }
                if (this.isProbablyBranch(newName)) {
                    GitRepoJob job = new GitRepoJob(GitRepository.this, GitRepository.this, "Firing pull and push event"){

                        protected IStatus run(IProgressMonitor monitor) {
                            GitRepository.this.firePullEvent();
                            GitRepository.this.firePushEvent();
                            return Status.OK_STATUS;
                        }
                    };
                    job.schedule();
                }
            }

            private boolean isProbablyBranch(String newName) {
                return newName != null && newName.indexOf(File.separator) != -1 && !newName.endsWith(GitRepository.DOT_LOCK);
            }

            public void fileModified(int wd, String rootPath, String name) {
                if (name == null) {
                    return;
                }
                if (this.isProbablyBranch(name)) {
                    GitRepoJob job = new GitRepoJob(GitRepository.this, GitRepository.this, "Firing pull and push event"){

                        protected IStatus run(IProgressMonitor monitor) {
                            GitRepository.this.firePullEvent();
                            GitRepository.this.firePushEvent();
                            return Status.OK_STATUS;
                        }
                    };
                    job.schedule();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void fileDeleted(int wd, String rootPath, final String name) {
                if (this.isProbablyBranch(name)) {
                    if (GitRepository.this.branches != null) {
                        Set set = GitRepository.this.branches;
                        synchronized (set) {
                            GitRepository.this.branches.remove(new GitRevSpecifier(GitRef.refFromString("refs/remotes/" + name)));
                        }
                    }
                    GitRepoJob job = new GitRepoJob(GitRepository.this, GitRepository.this, "Firing branch removed and pull event"){

                        protected IStatus run(IProgressMonitor monitor) {
                            GitRepository.this.fireBranchRemovedEvent(name);
                            GitRepository.this.firePullEvent();
                            return Status.OK_STATUS;
                        }
                    };
                    job.schedule();
                }
            }

            public void fileCreated(int wd, String rootPath, final String name) {
                if (this.isProbablyBranch(name)) {
                    GitRepository.this.addBranch(new GitRevSpecifier(GitRef.refFromString("refs/remotes/" + name)));
                    GitRepoJob job = new GitRepoJob(GitRepository.this, GitRepository.this, "Firing branch added and pull event"){

                        protected IStatus run(IProgressMonitor monitor) {
                            GitRepository.this.fireBranchAddedEvent(name);
                            GitRepository.this.firePullEvent();
                            return Status.OK_STATUS;
                        }
                    };
                    job.schedule();
                }
            }
        }));
    }

    public IPath workingDirectory() {
        if (this.gitDirPath().lastSegment().equals(GIT_DIR)) {
            return this.gitDirPath().removeLastSegments(1);
        }
        IStatus result = this.execute(ReadWrite.READ, this.gitDirPath(), "rev-parse", "--is-inside-work-tree");
        if (result != null && result.isOK() && result.getMessage().trim().equals("true")) {
            return this.getGitExecutable().path();
        }
        return null;
    }

    public Set<String> localBranches() {
        return this.simpleRefsOfType(GitRef.TYPE.HEAD);
    }

    public Set<String> remoteBranches() {
        return this.simpleRefsOfType(GitRef.TYPE.REMOTE);
    }

    public Set<String> remotes() {
        TreeSet<String> set = new TreeSet<String>();
        String contents = this.configContents();
        if (!StringUtil.isEmpty((String)contents)) {
            Matcher m = fgRemoteNamePattern.matcher(contents);
            while (m.find()) {
                set.add(m.group(1));
            }
        } else {
            Set<String> remoteBranches = this.remoteBranches();
            for (String branch : remoteBranches) {
                set.add(GitRef.refFromString("refs/remotes/" + branch).getRemoteName());
            }
        }
        return set;
    }

    public Set<String> allBranches() {
        return this.simpleRefsOfType(GitRef.TYPE.HEAD, GitRef.TYPE.REMOTE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedSet<GitRef> simpleRefs() {
        TreeSet<GitRef> refs = new TreeSet<GitRef>(new GitRefComparator());
        if (this.branches == null) {
            return refs;
        }
        Set<GitRevSpecifier> set = this.branches;
        synchronized (set) {
            for (GitRevSpecifier revSpec : this.branches) {
                GitRef ref;
                if (!revSpec.isSimpleRef() || (ref = revSpec.simpleRef()) == null || ref.type() == null || ref.type() == GitRef.TYPE.HEAD && ref.shortName().endsWith(DOT_LOCK)) continue;
                refs.add(ref);
            }
        }
        return refs;
    }

    private Set<String> simpleRefsOfType(GitRef.TYPE ... types) {
        if (ArrayUtil.isEmpty((Object[])types)) {
            return Collections.emptySet();
        }
        HashSet<GitRef.TYPE> validTypes = new HashSet<GitRef.TYPE>(Arrays.asList(types));
        TreeSet<String> allBranches = new TreeSet<String>(new BranchNameComparator());
        SortedSet<GitRef> simpleRefs = this.simpleRefs();
        for (GitRef ref : simpleRefs) {
            if (!validTypes.contains((Object)ref.type())) continue;
            allBranches.add(ref.shortName());
        }
        return allBranches;
    }

    public IStatus switchBranch(String branchName, IProgressMonitor monitor) {
        if (branchName == null) {
            return new Status(4, "com.aptana.git.core", Messages.GitRepository_ERR_BranchNotProvided);
        }
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)4);
        try {
            Set<IProject> projectsNotExistingOnNewBranch = this.getProjectsThatDontExistOnBranch(branchName, (IProgressMonitor)sub.newChild(1));
            this.closeProjects(projectsNotExistingOnNewBranch, (IProgressMonitor)sub.newChild(1));
            String oldBranchName = this.currentBranch.simpleRef().shortName();
            IStatus result = this.execute(ReadWrite.WRITE, "checkout", branchName);
            sub.worked(1);
            if (result == null || !result.isOK()) {
                this.openProjects(projectsNotExistingOnNewBranch, (IProgressMonitor)sub.newChild(1));
                IStatus iStatus = result;
                return iStatus;
            }
            this._headRef = null;
            this.readCurrentBranch();
            this.fireBranchChangeEvent(oldBranchName, branchName);
            sub.worked(1);
            IStatus iStatus = result;
            return iStatus;
        }
        finally {
            sub.done();
        }
    }

    private void openProjects(Set<IProject> projects, IProgressMonitor monitor) {
        if (projects == null) {
            return;
        }
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)projects.size());
        for (IProject project : projects) {
            try {
                project.open((IProgressMonitor)sub.newChild(1));
            }
            catch (CoreException e) {
                IdeLog.logError((Plugin)GitPlugin.getDefault(), (Throwable)e, (String)"com.aptana.git.core/debug");
            }
        }
        sub.done();
    }

    private void closeProjects(Set<IProject> projects, IProgressMonitor monitor) {
        if (projects == null) {
            return;
        }
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)projects.size());
        for (IProject project : projects) {
            try {
                project.close((IProgressMonitor)sub.newChild(1));
            }
            catch (CoreException e) {
                IdeLog.logError((Plugin)GitPlugin.getDefault(), (Throwable)e, (String)"com.aptana.git.core/debug");
            }
        }
        sub.done();
    }

    private Set<IProject> getProjectsThatDontExistOnBranch(String branchName, IProgressMonitor monitor) {
        IPath workingDir = this.workingDirectory();
        IContainer c = ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation(workingDir);
        if (c instanceof IProject) {
            return Collections.emptySet();
        }
        ArrayList<IProject> beneathRepo = new ArrayList<IProject>();
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (workingDir.isPrefixOf(project.getLocation())) {
                beneathRepo.add(project);
            }
            ++n2;
        }
        if (beneathRepo.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<IProject> projectsNotExistingOnNewBranch = new HashSet<IProject>();
        StringBuilder input = new StringBuilder();
        for (IProject project : beneathRepo) {
            input.append(branchName).append(':').append(this.relativePath((IResource)project).append(".project").toPortableString()).append('\n');
        }
        if (!this.enterRead()) {
            IdeLog.logError((Plugin)GitPlugin.getDefault(), (String)Messages.GitRepository_FailedAcquireReadLock);
            return Collections.emptySet();
        }
        IStatus result = this.getGitExecutable().runInBackground(input.toString(), workingDir, "cat-file", "--batch-check");
        this.exitRead();
        if (result.isOK()) {
            String output = result.getMessage();
            String[] lines = output.split("\r?\n|\r");
            int lineNum = 0;
            String[] stringArray = lines;
            int n3 = lines.length;
            int n4 = 0;
            while (n4 < n3) {
                String line = stringArray[n4];
                if (line.endsWith(" missing")) {
                    projectsNotExistingOnNewBranch.add((IProject)beneathRepo.get(lineNum));
                }
                ++lineNum;
                ++n4;
            }
        }
        HashSet<IProject> workingCopies = new HashSet<IProject>();
        for (IProject project : projectsNotExistingOnNewBranch) {
            String path = this.relativePath((IResource)project).append(".project").toPortableString();
            result = this.execute(ReadWrite.READ, "ls-files", "--others", "--exclude-standard", "-z", "--", path);
            if (!result.isOK() || !result.getMessage().trim().equals(path)) continue;
            workingCopies.add(project);
        }
        projectsNotExistingOnNewBranch.removeAll(workingCopies);
        return projectsNotExistingOnNewBranch;
    }

    private void readCurrentBranch() {
        this.currentBranch = this.addBranch(this.headRef());
    }

    private boolean reloadRefs() {
        this._headRef = null;
        boolean ret = false;
        this.refs = new HashMap<String, List<GitRef>>();
        IStatus result = this.execute(ReadWrite.READ, "for-each-ref", "--format=%(refname) %(objecttype) %(objectname) %(*objectname)", "refs");
        String output = result.getMessage();
        List lines = StringUtil.tokenize((String)output, (String)"\n");
        for (String line : lines) {
            if (line.length() == 0) continue;
            List components = StringUtil.tokenize((String)line, (String)" ");
            GitRef newRef = GitRef.refFromString((String)components.get(0));
            GitRevSpecifier revSpec = new GitRevSpecifier(newRef);
            if (!this.addBranch(revSpec).equals(revSpec)) {
                ret = true;
            }
            this.addRef(newRef, components);
        }
        this.addBranch(GitRevSpecifier.allBranchesRevSpec());
        this.addBranch(GitRevSpecifier.localBranchesRevSpec());
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GitRevSpecifier addBranch(GitRevSpecifier rev) {
        if (rev.parameters().isEmpty()) {
            rev = this.headRef();
        }
        if (this.branches != null) {
            Set<GitRevSpecifier> set = this.branches;
            synchronized (set) {
                this.branches.add(rev);
            }
        }
        return rev;
    }

    public GitRevSpecifier headRef() {
        if (this._headRef != null) {
            return this._headRef;
        }
        String branch = this.parseSymbolicReference(HEAD);
        this._headRef = branch != null && branch.startsWith("refs/heads/") ? new GitRevSpecifier(GitRef.refFromString(branch)) : new GitRevSpecifier(GitRef.refFromString(HEAD));
        return this._headRef;
    }

    private String parseSymbolicReference(String reference) {
        IStatus result = this.execute(ReadWrite.READ, "symbolic-ref", "-q", reference);
        if (result == null || !result.isOK()) {
            return null;
        }
        String ref = result.getMessage();
        if (ref != null && ref.startsWith("refs/")) {
            return ref;
        }
        return null;
    }

    private void addRef(GitRef ref, List<String> components) {
        String type = components.get(1);
        String sha = type.equals((Object)GitRef.TYPE.TAG) && components.size() == 4 ? components.get(3) : components.get(2);
        if (this.refs == null) {
            return;
        }
        List<GitRef> curRefs = this.refs.get(sha);
        if (curRefs != null) {
            curRefs.add(ref);
        } else {
            curRefs = new ArrayList<GitRef>();
            curRefs.add(ref);
            this.refs.put(sha, curRefs);
        }
    }

    public String currentBranch() {
        if (this.currentBranch == null) {
            return null;
        }
        return this.currentBranch.simpleRef().shortName();
    }

    public synchronized GitIndex index() {
        if (this.index == null) {
            this.index = new GitIndex(this);
        }
        return this.index;
    }

    private void fireBranchChangeEvent(String oldBranchName, String newBranchName) {
        if (CollectionsUtil.isEmpty(this.listeners)) {
            return;
        }
        try {
            HashSet<IGitRepositoryListener> copy = new HashSet<IGitRepositoryListener>(this.listeners);
            BranchChangedEvent e = new BranchChangedEvent(this, oldBranchName, newBranchName);
            for (IGitRepositoryListener listener : copy) {
                listener.branchChanged(e);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private void fireBranchRemovedEvent(String oldBranchName) {
        if (CollectionsUtil.isEmpty(this.listeners)) {
            return;
        }
        try {
            HashSet<IGitRepositoryListener> copy = new HashSet<IGitRepositoryListener>(this.listeners);
            BranchRemovedEvent e = new BranchRemovedEvent(this, oldBranchName);
            for (IGitRepositoryListener listener : copy) {
                listener.branchRemoved(e);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private void fireBranchAddedEvent(String newBranchName) {
        if (CollectionsUtil.isEmpty(this.listeners)) {
            return;
        }
        try {
            HashSet<IGitRepositoryListener> copy = new HashSet<IGitRepositoryListener>(this.listeners);
            BranchAddedEvent e = new BranchAddedEvent(this, newBranchName);
            for (IGitRepositoryListener listener : copy) {
                listener.branchAdded(e);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    void fireIndexChangeEvent(Collection<ChangedFile> preChangeFiles, Collection<ChangedFile> changedFiles) {
        if (CollectionsUtil.isEmpty(this.listeners)) {
            return;
        }
        IndexChangedEvent e = new IndexChangedEvent(this, preChangeFiles, changedFiles);
        if (!e.hasDiff()) {
            return;
        }
        try {
            HashSet<IGitRepositoryListener> copy = new HashSet<IGitRepositoryListener>(this.listeners);
            for (IGitRepositoryListener listener : copy) {
                listener.indexChanged(e);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void lazyReload() {
        if (!this.hasChanged) {
            return;
        }
        this.reloadRefs();
        this.hasChanged = false;
    }

    void hasChanged() {
        this.hasChanged = true;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GitRepository)) {
            return false;
        }
        GitRepository other = (GitRepository)obj;
        return this.fileURL.getPath().equals(other.fileURL.getPath());
    }

    public int hashCode() {
        return this.fileURL.getPath().hashCode();
    }

    public String[] commitsAhead(String branchName) {
        GitRef remote = this.matchingRemoteBranch(branchName);
        if (remote == null) {
            return null;
        }
        return this.index().commitsBetween(remote.ref(), "refs/heads/" + branchName);
    }

    public GitRef matchingRemoteBranch(String localBranchName) {
        GitRef remote = this.remoteTrackingBranch(localBranchName);
        if (remote != null) {
            return remote;
        }
        String remoteMatchingName = MessageFormat.format("{0}{1}{2}", ORIGIN, Character.valueOf('/'), localBranchName);
        if (this.remoteBranches().contains(remoteMatchingName)) {
            return GitRef.refFromString("refs/remotes/" + remoteMatchingName);
        }
        return null;
    }

    public ChangedFile getChangedFileForResource(IResource resource) {
        return this.index().getChangedFileForResource(resource);
    }

    public String[] commitsBehind(String branchName) {
        GitRef remote = this.matchingRemoteBranch(branchName);
        if (remote == null) {
            return null;
        }
        return this.index().commitsBetween("refs/heads/" + branchName, remote.ref());
    }

    public boolean isDirty() {
        return this.index().isDirty();
    }

    private GitRef remoteTrackingBranch(String branchName) {
        String[] lines;
        int trailingBracket;
        String contents = this.configContents();
        if (StringUtil.isEmpty((String)contents)) {
            return null;
        }
        int index = contents.indexOf("merge = refs/heads/" + branchName);
        if (index == -1) {
            return null;
        }
        int precedingBracket = contents.lastIndexOf(91, index);
        if (precedingBracket == -1) {
            precedingBracket = 0;
        }
        if ((trailingBracket = contents.indexOf(91, index)) == -1) {
            trailingBracket = contents.length();
        }
        String branchDetails = contents.substring(precedingBracket, trailingBracket);
        String remoteBranchName = null;
        String remoteName = ORIGIN;
        String[] stringArray = lines = StringUtil.LINE_SPLITTER.split(branchDetails);
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if ((line = line.trim()).startsWith("remote = ")) {
                remoteName = line.substring(9);
            } else if (line.startsWith("[branch \"")) {
                remoteBranchName = line.substring(9, line.length() - 2);
            }
            ++n2;
        }
        if (remoteBranchName == null) {
            return null;
        }
        return GitRef.refFromString(MessageFormat.format("{0}{1}{2}{3}", "refs/remotes/", remoteName, Character.valueOf('/'), remoteBranchName));
    }

    private String configContents() {
        if (!this.enterRead()) {
            IdeLog.logInfo((Plugin)GitPlugin.getDefault(), (String)Messages.GitRepository_FailedReadLockForConfig, (String)"com.aptana.git.core/debug");
            return null;
        }
        try {
            String string = IOUtil.read((InputStream)new FileInputStream(this.gitFile(CONFIG_FILENAME)));
            return string;
        }
        catch (FileNotFoundException e) {
            IdeLog.logWarning((Plugin)GitPlugin.getDefault(), (String)e.getMessage(), (Throwable)e, (String)"com.aptana.git.core/debug");
        }
        finally {
            this.exitRead();
        }
        return null;
    }

    public Set<String> remoteURLs() {
        try {
            return new HashSet<String>(this.remotePairs().values());
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)GitPlugin.getDefault(), (Throwable)e);
            return Collections.emptySet();
        }
    }

    public Map<String, String> remotePairs() throws CoreException {
        HashMap<String, String> pairs = new HashMap<String, String>();
        String contents = this.configContents();
        if (contents != null) {
            Matcher m = fgRemoteURLPattern.matcher(contents);
            while (m.find()) {
                pairs.put(m.group(1), m.group(3));
            }
            return pairs;
        }
        throw new CoreException((IStatus)new Status(4, "com.aptana.git.core", "Unable to acquire read lock to read .git/config file"));
    }

    public boolean createBranch(String branchName, boolean track, String startPoint) {
        IStatus result;
        ArrayList<String> args = new ArrayList<String>();
        args.add("branch");
        if (track) {
            args.add("--track");
        } else {
            args.add("--no-track");
        }
        args.add(branchName);
        if (startPoint != null && startPoint.trim().length() > 0) {
            args.add(startPoint);
        }
        if ((result = this.execute(ReadWrite.WRITE, args.toArray(new String[args.size()]))) == null || !result.isOK()) {
            return false;
        }
        this.addBranch(new GitRevSpecifier(GitRef.refFromString("refs/heads/" + branchName)));
        this.fireBranchAddedEvent(branchName);
        return true;
    }

    public IStatus deleteBranch(String branchName) {
        return this.deleteBranch(branchName, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus deleteBranch(String branchName, boolean force) {
        ArrayList<String> args = new ArrayList<String>();
        args.add("branch");
        if (!force) {
            args.add("-d");
        } else {
            args.add("-D");
        }
        args.add(branchName);
        IStatus result = this.execute(ReadWrite.WRITE, args.toArray(new String[args.size()]));
        if (!result.isOK()) {
            return new Status(4, GitPlugin.getPluginId(), result.getCode(), result.getMessage(), null);
        }
        if (this.branches != null) {
            Set<GitRevSpecifier> set = this.branches;
            synchronized (set) {
                this.branches.remove(new GitRevSpecifier(GitRef.refFromString("refs/heads/" + branchName)));
            }
        }
        this.fireBranchRemovedEvent(branchName);
        return Status.OK_STATUS;
    }

    public boolean validRefName(String refName) {
        IStatus result = this.execute(ReadWrite.READ, "check-ref-format", refName);
        return result != null && result.isOK();
    }

    public IStatus deleteFile(IPath filePath) {
        IStatus result = this.execute(ReadWrite.WRITE, "rm", "-f", filePath.toPortableString());
        if (result == null) {
            return new Status(4, GitPlugin.getPluginId(), "Failed to execute git rm -f");
        }
        if (!result.isOK()) {
            return new Status(4, GitPlugin.getPluginId(), result.getCode(), result.getMessage(), null);
        }
        return Status.OK_STATUS;
    }

    public IStatus execute(ReadWrite readOrWrite, String ... args) {
        return this.execute(readOrWrite, this.workingDirectory(), args);
    }

    private IStatus execute(ReadWrite readOrWrite, IPath workingDir, String ... args) {
        return this.execute(readOrWrite, workingDir, (Map<String, String>)null, args);
    }

    IStatus executeWithPromptHandling(ReadWrite readOrWrite, String ... args) {
        return this.execute(readOrWrite, this.workingDirectory(), this.gitEnvironment(), args);
    }

    protected Map<String, String> gitEnvironment() {
        return GitExecutable.getEnvironment();
    }

    IStatus execute(ReadWrite readOrWrite, IPath workingDir, Map<String, String> env, String ... args) {
        boolean acquired = false;
        switch (readOrWrite) {
            case READ: {
                acquired = this.enterRead();
                break;
            }
            case WRITE: {
                acquired = this.enterWriteProcess();
            }
        }
        if (!acquired) {
            return new Status(4, GitPlugin.getPluginId(), Messages.GitRepository_FailedAcquireLock);
        }
        try {
            IStatus iStatus = this.getGitExecutable().runInBackground(workingDir, env, args);
            return iStatus;
        }
        finally {
            switch (readOrWrite) {
                case READ: {
                    this.exitRead();
                    break;
                }
                case WRITE: {
                    this.exitWriteProcess();
                }
            }
        }
    }

    protected GitExecutable getGitExecutable() {
        return GitExecutable.instance();
    }

    IStatus executeWithInput(String input, String ... args) {
        if (!this.enterWriteProcess()) {
            return new Status(4, GitPlugin.getPluginId(), Messages.GitRepository_FailedAcquireWriteLock);
        }
        try {
            IStatus iStatus = this.getGitExecutable().runInBackground(input, this.workingDirectory(), args);
            return iStatus;
        }
        finally {
            this.exitWriteProcess();
        }
    }

    public IStatus deleteFolder(IPath folderPath) {
        IStatus result = this.execute(ReadWrite.WRITE, "rm", "-rf", folderPath.toOSString());
        if (result == null) {
            return new Status(4, GitPlugin.getPluginId(), "Failed to execute git rm -rf");
        }
        if (!result.isOK()) {
            return new Status(4, GitPlugin.getPluginId(), result.getCode(), result.getMessage(), null);
        }
        return Status.OK_STATUS;
    }

    public IStatus moveFile(IPath source, IPath dest) {
        IStatus result = this.execute(ReadWrite.WRITE, "mv", source.toOSString(), dest.toOSString());
        if (result == null || !result.isOK()) {
            return new Status(4, GitPlugin.getPluginId(), result == null ? 0 : result.getCode(), result == null ? null : result.getMessage(), null);
        }
        return Status.OK_STATUS;
    }

    public IPath relativePath(IResource theResource) {
        IPath workingDirectory = this.workingDirectory();
        IPath resourcePath = theResource.getLocation();
        if (theResource instanceof IProject && resourcePath == null) {
            resourcePath = ResourcesPlugin.getWorkspace().getRoot().getLocation().append(theResource.getName());
        }
        if (workingDirectory.isPrefixOf(resourcePath)) {
            resourcePath = resourcePath.makeRelativeTo(workingDirectory);
        }
        return resourcePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> allSimpleRefs() {
        HashSet<String> allRefs = new HashSet<String>();
        if (this.branches != null) {
            Set<GitRevSpecifier> set = this.branches;
            synchronized (set) {
                for (GitRevSpecifier revSpec : this.branches) {
                    GitRef ref;
                    if (!revSpec.isSimpleRef() || (ref = revSpec.simpleRef()) == null || ref.type() == null) continue;
                    allRefs.add(ref.shortName());
                }
            }
        }
        return allRefs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispose() {
        if (this.fileWatcherIds != null) {
            for (Integer fileWatcherId : this.fileWatcherIds) {
                try {
                    FileWatcher.removeWatch((int)fileWatcherId);
                }
                catch (JNotifyException e) {
                    IdeLog.logWarning((Plugin)GitPlugin.getDefault(), (Throwable)e, (String)"com.aptana.git.core/debug");
                }
            }
        }
        this.fileWatcherIds = null;
        Job.getJobManager().cancel((Object)this);
        if (this.index != null) {
            this.index.dispose();
            this.index = null;
        }
        if (this.listeners != null) {
            Set<IGitRepositoryListener> set = this.listeners;
            synchronized (set) {
                this.listeners.clear();
                this.listeners = null;
            }
        }
        this._headRef = null;
        this.hasChanged = false;
        this.refs = null;
        this.branches = null;
    }

    public boolean hasUnresolvedMergeConflicts() {
        return this.index().hasUnresolvedMergeConflicts();
    }

    public List<String> getMergeSHAs() {
        ArrayList<String> shas;
        block14: {
            shas = new ArrayList<String>();
            if (!this.mergeHeadFile().exists()) {
                return shas;
            }
            BufferedReader reader = null;
            try {
                try {
                    reader = new BufferedReader(new FileReader(this.mergeHeadFile()));
                    String sha = null;
                    while ((sha = reader.readLine()) != null) {
                        shas.add(sha);
                    }
                }
                catch (Exception e) {
                    IdeLog.logError((Plugin)GitPlugin.getDefault(), (Throwable)e, (String)"com.aptana.git.core/debug");
                    if (reader == null) break block14;
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return shas;
    }

    private File mergeHeadFile() {
        return this.gitFile(MERGE_HEAD_FILENAME);
    }

    File gitFile(String string) {
        return this.gitDirPath().append(string).toFile();
    }

    private IPath gitDirPath() {
        File file = new File(this.fileURL);
        try {
            return Path.fromOSString((String)file.getCanonicalPath());
        }
        catch (IOException e) {
            return Path.fromOSString((String)file.getAbsolutePath());
        }
    }

    public void firePullEvent() {
        if (this.listeners == null || this.listeners.isEmpty()) {
            return;
        }
        PullEvent e = new PullEvent(this);
        for (IGitRepositoryListener listener : this.listeners) {
            listener.pulled(e);
        }
    }

    public void firePushEvent() {
        if (this.listeners == null || this.listeners.isEmpty()) {
            return;
        }
        PushEvent e = new PushEvent(this);
        for (IGitRepositoryListener listener : this.listeners) {
            listener.pushed(e);
        }
    }

    public boolean resourceOrChildHasChanges(IResource resource) {
        return this.index().resourceOrChildHasChanges(resource);
    }

    public List<ChangedFile> getChangedFilesForContainer(IContainer container) {
        return this.index().getChangedFilesForContainer(container);
    }

    URI getFileURL() {
        return this.fileURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(IGitRepositoryListener listener) {
        if (listener == null) {
            return;
        }
        if (this.listeners == null) {
            this.listeners = new HashSet<IGitRepositoryListener>(3);
        }
        Set<IGitRepositoryListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(IGitRepositoryListener listener) {
        if (listener == null || this.listeners == null) {
            return;
        }
        Set<IGitRepositoryListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(listener);
        }
    }

    public Set<IResource> getChangedResources() {
        return this.index().getChangedResources();
    }

    public IFile getFileForChangedFile(ChangedFile file) {
        return this.index().getResourceForChangedFile(file);
    }

    public String toSHA(GitRef ref) {
        block4: {
            File sha1File = this.gitFile(ref.ref());
            try {
                if (!sha1File.isFile()) {
                    File packedRefs = this.gitFile(PACKED_REFS);
                    String packedRefContents = IOUtil.read((InputStream)new FileInputStream(packedRefs));
                    int index = packedRefContents.indexOf(ref.ref());
                    if (index != -1) {
                        return new String(packedRefContents.substring(index - 41, index - 1));
                    }
                    break block4;
                }
                return IOUtil.read((InputStream)new FileInputStream(sha1File)).trim();
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return ref.ref();
    }

    public boolean ignoreResource(IResource resource) {
        IPath relativePath = this.relativePath(resource);
        return this.ignore(relativePath.toPortableString());
    }

    public boolean ignore(String pattern) {
        File gitIgnore = new File(this.workingDirectory().toFile(), GITIGNORE);
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(new FileWriter(gitIgnore, true));
            writer.println(pattern);
            return true;
        }
        catch (IOException e) {
            IdeLog.logError((Plugin)GitPlugin.getDefault(), (Throwable)e, (String)"com.aptana.git.core/debug");
            return false;
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    public synchronized Set<String> getOutOfDateBranches() {
        boolean performFetches = Platform.getPreferencesService().getBoolean(GitPlugin.getPluginId(), "git_calculate_pull_indicator", false, null);
        if (!performFetches) {
            return Collections.emptySet();
        }
        HashMap<String, GitRef> localToRemote = new HashMap<String, GitRef>();
        for (String branchName : this.localBranches()) {
            GitRef remote = this.matchingRemoteBranch(branchName);
            if (remote == null) continue;
            localToRemote.put(branchName, remote);
        }
        if (localToRemote.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> toPull = new HashSet<String>();
        Iterator iter = localToRemote.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String[] commits = this.index().commitsBetween("refs/heads/" + (String)entry.getKey(), ((GitRef)entry.getValue()).ref());
            if (commits == null || commits.length <= 0) continue;
            toPull.add((String)entry.getKey());
            iter.remove();
        }
        if (localToRemote.isEmpty()) {
            return toPull;
        }
        HashMap<String, String> remoteNameToOutput = new HashMap<String, String>();
        for (Map.Entry entry : localToRemote.entrySet()) {
            String remote = ((GitRef)entry.getValue()).getRemoteName();
            if (remoteNameToOutput.containsKey(remote)) continue;
            IStatus result = this.executeWithPromptHandling(ReadWrite.READ, "ls-remote", "--heads", remote);
            if (result == null || !result.isOK()) {
                if (result != null) {
                    GitPlugin.getDefault().getLog().log(result);
                }
                remoteNameToOutput.put(remote, "");
                continue;
            }
            remoteNameToOutput.put(remote, result.getMessage());
        }
        Pattern p = Pattern.compile("^([0-9a-fA-F]{40})\\s+(refs/heads/.+)$", 8);
        block3: for (Map.Entry entry : remoteNameToOutput.entrySet()) {
            String output = (String)entry.getValue();
            if (output.length() == 0) continue;
            Matcher m = p.matcher(output);
            while (m.find()) {
                String localSHA;
                String remoteSHA = m.group(1);
                String ref = m.group(2);
                String localBranchName = null;
                for (Map.Entry localToRemoteRefEntry : localToRemote.entrySet()) {
                    if (!((String)entry.getKey()).equals(((GitRef)localToRemoteRefEntry.getValue()).getRemoteName()) || !ref.equals("refs/heads/" + ((GitRef)localToRemoteRefEntry.getValue()).getRemoteBranchName())) continue;
                    localBranchName = (String)localToRemoteRefEntry.getKey();
                    break;
                }
                if (localBranchName == null || (localSHA = this.toSHA(GitRef.refFromString("refs/heads/" + localBranchName))).equals(remoteSHA)) continue;
                toPull.add(localBranchName);
                localToRemote.remove(localBranchName);
                if (localToRemote.isEmpty()) continue block3;
            }
        }
        return toPull;
    }

    public void exitWriteProcess() {
        try {
            this.monitor.writeLock().unlock();
        }
        catch (IllegalMonitorStateException e) {
            IdeLog.logError((Plugin)GitPlugin.getDefault(), (String)"Wrong thread is trying to unlock write lock.", (Throwable)e);
        }
        catch (Throwable t) {
            IdeLog.logError((Plugin)GitPlugin.getDefault(), (Throwable)t);
        }
    }

    public boolean enterWriteProcess() {
        return this.monitor.writeLock().tryLock();
    }

    boolean enterRead() {
        return this.monitor.readLock().tryLock();
    }

    void exitRead() {
        try {
            this.monitor.readLock().unlock();
        }
        catch (Throwable t) {
            IdeLog.logError((Plugin)GitPlugin.getDefault(), (Throwable)t);
        }
    }

    public Set<String> getGithubURLs() {
        HashSet<String> githubURLs = new HashSet<String>();
        for (String remoteURL : this.remoteURLs()) {
            int split;
            if (!remoteURL.contains(GITHUB_COM)) continue;
            String remaining = remoteURL.substring(remoteURL.indexOf(GITHUB_COM) + 10);
            if (remaining.length() > 0 && (remaining.charAt(0) == '/' || remaining.charAt(0) == ':')) {
                remaining = remaining.substring(1);
            }
            if (remaining.endsWith(GIT_DIR)) {
                remaining = remaining.substring(0, remaining.length() - 4);
            }
            if ((split = remaining.indexOf(47)) <= -1) continue;
            String userName = remaining.substring(0, split);
            String repoName = remaining.substring(split + 1);
            githubURLs.add(MessageFormat.format("https://github.com/{0}/{1}", userName, repoName));
        }
        return githubURLs;
    }

    public String getPrepopulatedCommitMessage() {
        try {
            File mergeMsg = this.gitFile(MERGE_MSG);
            if (mergeMsg.exists()) {
                return IOUtil.read((InputStream)new FileInputStream(mergeMsg));
            }
            File squashMsg = this.gitFile(SQUASH_MSG);
            if (squashMsg.exists()) {
                return IOUtil.read((InputStream)new FileInputStream(squashMsg));
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return "";
    }

    public boolean autoSetupMerge() {
        IStatus status = this.execute(ReadWrite.READ, CONFIG_FILENAME, "branch.autosetupmerge");
        return status != null && status.isOK() && Boolean.valueOf(status.getMessage().trim()) != false;
    }

    public IStatus createTag(String tagName, String message, String startPoint) {
        IStatus result;
        ArrayList<String> args = new ArrayList<String>();
        args.add("tag");
        args.add("-a");
        args.add(tagName);
        args.add("-m");
        args.add(message);
        if (!StringUtil.isEmpty((String)startPoint)) {
            args.add(startPoint);
        }
        if ((result = this.execute(ReadWrite.WRITE, args.toArray(new String[args.size()]))) != null && result.isOK()) {
            this.addBranch(new GitRevSpecifier(GitRef.refFromString("refs/tags/" + tagName)));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> tags() {
        TreeSet<String> tags = new TreeSet<String>();
        if (this.branches != null) {
            Set<GitRevSpecifier> set = this.branches;
            synchronized (set) {
                for (GitRevSpecifier revSpec : this.branches) {
                    GitRef ref;
                    if (!revSpec.isSimpleRef() || (ref = revSpec.simpleRef()) == null || ref.type() == null || !ref.type().equals((Object)GitRef.TYPE.TAG)) continue;
                    tags.add(ref.shortName());
                }
            }
        }
        return tags;
    }

    public IStatus revParse(String ref) {
        return this.execute(ReadWrite.READ, "rev-parse", "--verify", ref);
    }

    void waitForWrite() {
        this.monitor.writeLock().lock();
    }

    public IStatus removeRemote(String remoteName) {
        return this.execute(ReadWrite.WRITE, "remote", "rm", remoteName);
    }

    public IStatus addRemote(String remoteName, String url, boolean track) {
        return this.addRemote(remoteName, url, track, true);
    }

    public IStatus addRemote(String remoteName, String url, boolean track, boolean fetch) {
        List args = CollectionsUtil.newList((Object[])new String[]{"remote", "add"});
        if (fetch) {
            args.add("-f");
        }
        if (track) {
            CollectionsUtil.addToList((List)args, (Object[])new String[]{"--track", this.currentBranch()});
        }
        CollectionsUtil.addToList((List)args, (Object[])new String[]{remoteName, url});
        return this.execute(ReadWrite.WRITE, (String[])CollectionsUtil.toArray((List)args));
    }

    void forceRead() {
        this.monitor.readLock().lock();
    }

    void forceWrite() {
        this.monitor.writeLock().lock();
    }

    public IStatus push(String ... args) {
        String[] fullArgs = new String[args.length + 1];
        fullArgs[0] = "push";
        System.arraycopy(args, 0, fullArgs, 1, args.length);
        IStatus result = this.execute(ReadWrite.WRITE, fullArgs);
        if (result == null || !result.isOK()) {
            return result;
        }
        this.firePushEvent();
        return result;
    }

    public IStatus pull(String ... args) {
        String[] fullArgs = new String[args.length + 1];
        fullArgs[0] = "pull";
        System.arraycopy(args, 0, fullArgs, 1, args.length);
        IStatus result = this.execute(ReadWrite.WRITE, this.workingDirectory(), this.gitEnvironment(), fullArgs);
        if (result == null || !result.isOK()) {
            return result;
        }
        this.firePullEvent();
        return result;
    }

    public IGithubRepository getGithubRepo() throws CoreException {
        String repoName = this.getGithubRepoName();
        if (StringUtil.isEmpty((String)repoName)) {
            throw new CoreException((IStatus)new Status(4, "com.aptana.git.core", 1235, Messages.GitRepository_NoGithubRemoteAttachedErr, null));
        }
        List pair = StringUtil.split((String)repoName, (char)'/');
        return this.getGithubManager().getRepo((String)pair.get(0), (String)pair.get(1));
    }

    protected IGithubManager getGithubManager() {
        return GitPlugin.getDefault().getGithubManager();
    }

    String getGithubRepoName() {
        Matcher m;
        block5: {
            String remoteURL;
            block4: {
                try {
                    Map<String, String> pairs = this.remotePairs();
                    remoteURL = pairs.get(ORIGIN);
                    if (remoteURL != null) break block4;
                    return null;
                }
                catch (CoreException e) {
                    return null;
                }
            }
            Pattern p = Pattern.compile(GITHUB_REMOTE_REGEX);
            m = p.matcher(remoteURL);
            if (m.find()) break block5;
            return null;
        }
        return String.valueOf(m.group(5)) + '/' + m.group(6);
    }

    public boolean hasGithubRemote() {
        return this.getGithubRepoName() != null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class BranchNameComparator
    implements Comparator<String> {
        private BranchNameComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            if (o1.indexOf(47) != -1 && o2.indexOf(47) == -1) {
                return 1;
            }
            if (o2.indexOf(47) != -1 && o1.indexOf(47) == -1) {
                return -1;
            }
            return o1.compareTo(o2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class GitRefComparator
    implements Comparator<GitRef> {
        private GitRefComparator() {
        }

        @Override
        public int compare(GitRef o1, GitRef o2) {
            int diff = o1.type().ordinal() - o2.type().ordinal();
            if (diff != 0) {
                return diff;
            }
            return o1.toString().compareTo(o2.toString());
        }
    }

    private abstract class GitRepoJob
    extends Job {
        private GitRepository repo;

        private GitRepoJob(GitRepository repo, String name) {
            super(name);
            this.repo = repo;
            EclipseUtil.setSystemForJob((Job)this);
        }

        public boolean belongsTo(Object family) {
            return this.repo.equals(family);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ReadWrite {
        READ,
        WRITE;

    }
}

